(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     91925,       1593]
NotebookOptionsPosition[     91553,       1576]
NotebookOutlinePosition[     92015,       1595]
CellTagsIndexPosition[     91972,       1592]
WindowTitle->Geometric Optics main palette
WindowFrame->Palette*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 TemplateBox[{InterpretationBox[
    StyleBox[
     GraphicsBox[{}, ImageSize -> {15, 0}, BaselinePosition -> Baseline], 
     "CacheGraphics" -> False], 
    Spacer[15]],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3Xm8rXP5//HLOcc8Ox1jZvE1ZgghmX5UkmQmIvNQyJBUOtJEJb5EIhKJ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         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> (Get["GeometricOptics`"]; 
       Map[GeometricOptics`LoadPackage, 
         Normal[
          GeometricOptics`$InstalledPackages[All, "PackageName"]]]), Method -> 
      "Queued", Appearance -> "Frameless", ImageSize -> {50, 50}, Evaluator -> 
      Automatic], "\"Load all installed packages\"", LabelStyle -> 
     "TextStyling"], 
    Annotation[#, "Load all installed packages", "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3U+o5WUdx/E7Y5Q2LqKYWeSmXFgRzK5BSYQGK4L+oPaHcKOVpRFTjkEY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         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> (Needs["GeometricOptics`"]; 
       GeometricOptics`Private`selectedPackages$8081 = {}; CreatePalette[{
          Column[{
            Spacer[3], 
            TextCell["Select one or more package to load"], 
            Spacer[3], 
            Row[{
              Button[
               Tooltip[GeometricOptics`selectAllIcon, "Select all packages"], 
               GeometricOptics`Private`selectedPackages$8081 = Normal[
                 GeometricOptics`$InstalledPackages[All, "PackageName"]], 
               ImageSize -> {30, 30}, Appearance -> "Framed"], 
              Spacer[10], 
              Button[
               Tooltip[
               GeometricOptics`clearAllIcon, "Clear current selection"], 
               GeometricOptics`Private`selectedPackages$8081 = {}, 
               ImageSize -> {30, 30}, Appearance -> "Framed"]}], 
            Spacer[3], 
            ListPicker[
             Dynamic[GeometricOptics`Private`selectedPackages$8081], 
             Thread[Normal[
                GeometricOptics`$InstalledPackages[All, "PackageName"]] -> 
              Map[StringJoin[
                 Riffle[#, " "]]& , 
                StringSplit[
                 Normal[
                  GeometricOptics`$InstalledPackages[All, "PackageName"]], 
                 RegularExpression["(?=[[:upper:]])"]]]]], 
            Spacer[5], 
            Row[{
              Button[
               Tooltip["Load", "Load only selected packages"], 
               Map[GeometricOptics`LoadPackage, 
                 GeometricOptics`Private`selectedPackages$8081]; 
               GeometricOptics`Private`selectedPackages$8081 = {}; 
               NotebookClose[
                 ButtonNotebook[]], Method -> "Queued"], 
              Spacer[2], 
              Button[
               Tooltip["Close", "Close without to load packages"], 
               GeometricOptics`Private`selectedPackages$8081 = {}; 
               NotebookClose[
                 ButtonNotebook[]]]}]}, Alignment -> Center]}, WindowMargins -> 
         Automatic, TextAlignment -> Center, WindowSize -> {250, 400}, 
         WindowTitle -> "Package loader"]), Method -> "Queued", Appearance -> 
      "Frameless", ImageSize -> {50, 50}, Evaluator -> Automatic], 
     "\"Choose packages to load\"", LabelStyle -> "TextStyling"], 
    Annotation[#, "Choose packages to load", "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3QnYJVV5J/BDLzSbIKsEFAUHJSDiuAQXiIooYpig6BBHGQUJikpwAIUO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         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> (Needs["GeometricOptics`"]; 
       GeometricOptics`Private`selectedPackages$8081 = {}; CreatePalette[{
          Column[{
            Spacer[3], 
            TextCell["Select one or more file to open"], 
            Spacer[3], 
            Row[{
              Button[
               Tooltip[GeometricOptics`selectAllIcon, "Select all files"], 
               GeometricOptics`Private`selectedPackages$8081 = Normal[
                 GeometricOptics`$InstalledPackages[All, "PackageName"]], 
               ImageSize -> {30, 30}, Appearance -> "Framed"], 
              Spacer[10], 
              Button[
               Tooltip[
               GeometricOptics`clearAllIcon, "Clear current selection"], 
               GeometricOptics`Private`selectedPackages$8081 = {}, 
               ImageSize -> {30, 30}, Appearance -> "Framed"]}], 
            Spacer[3], 
            ListPicker[
             Dynamic[GeometricOptics`Private`selectedPackages$8081], 
             Thread[Normal[
                GeometricOptics`$InstalledPackages[All, "PackageName"]] -> 
              Map[StringJoin[
                 Riffle[#, " "]]& , 
                StringSplit[
                 Normal[
                  GeometricOptics`$InstalledPackages[All, "PackageName"]], 
                 RegularExpression["(?=[[:upper:]])"]]]]], 
            Spacer[5], 
            Row[{
              Button[
               Tooltip["Open", "Open main file from selected packages"], 
               Map[NotebookOpen[
                  FileNameJoin[{GeometricOptics`$PackagesDirectory, #, 
                    StringJoin[#, ".nb"]}]]& , 
                 GeometricOptics`Private`selectedPackages$8081]; 
               GeometricOptics`Private`selectedPackages$8081 = {}; 
               NotebookClose[
                 ButtonNotebook[]], Method -> "Queued"], 
              Spacer[2], 
              Button[
               Tooltip["Close", "Close without to load packages"], 
               GeometricOptics`Private`selectedPackages$8081 = {}; 
               NotebookClose[
                 ButtonNotebook[]]]}]}, Alignment -> Center]}, WindowMargins -> 
         Automatic, TextAlignment -> Center, WindowSize -> {250, 400}, 
         WindowTitle -> "File opener"]), Method -> "Queued", Appearance -> 
      "Frameless", ImageSize -> {50, 50}, Evaluator -> Automatic], 
     "\"Package's file opener\"", LabelStyle -> "TextStyling"], 
    Annotation[#, "Package's file opener", "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3XvQbWVdwPGHc04IokcQJAYFuchN4jiMU6AWIjIJispN0YYhIAiYDOQy
GSFheGMgATEDRZhUCqbyGpYUTJgoCEMxKAINCAIphQkVEVdPv6f10hw47+bc
9lrPet/f5zfzEfCv/ay93vXd7373ftaWhx+3/28uKKWcuE78z/6Hve8NJ5xw
2MkHrB//8Y5jTzzmqGOPPGLvY0868qgjT9j18IXxf5YFnUXxj6VLlwIAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAwP+JWSusFzYJ24Sdw27hLeFd4YhwfPj9cFY4d8Yfhg+G3wsnhGPC
oeGg8LbwhrB9eFHrNQJARjN933mm5x8Il4Z/DA+Fp8LSnj0S7gzXhL8I54WT
wt5h89bHBwDmspjNwp7hPeET4e/CPeFnAzR+TfxHuDZcGN47s4aNWh9PABij
+rvzzHvunwv3jaDj03Zr+MzMGl/R+ngDQAsxP1+69/A/He4YQZ+Hdn/4Quk+
b7Bj6+cDAPoQs37Yt3R/L//eCPo7NvU10MdK93nFha2fLwBYXTHrhHeEvwpP
jKCxc8VPwp+E/cJ6rZ9HAFiR0n0H75dL977+gyNo6Vz33+Hz4Y1hQevnFwCW
FfOK8AfhByNo5nz1w/ChsE3r5xuAvGI2CEeHb4+gjdnU/Qfqfkb+PgDAIGK2
Kt37+4+OoIPZ/TR8OGzS+rwAYH6K2aF0389/cgTd45nqa7GLwitbnycAzA8x
rwp/XobZX5c1U/dHvDzs3vq8AWBuitmldN/da900Vs+3wq+0Po8AmBtiXl+6
/fZb94vp+Fp4VevzCoBxilkSrh5Br5i++neBPw1btT7PABiHmBeGc4rP9WXw
ePhk2Lj1eQdAOzEHhX8ZQZcYVt2bse7dsFbrcxCA4cRsV/yNn1KuLT4bADDv
xaxbuv1iHhtBexiHem+meu/BF7Q+PwGYvpi3hrtG0BvG6Z6wb+vzFIDpiHlJ
+PII+tK3h8PN4R9K9523y8KF4ezS3ZvopHBUeHfpXgvtNeNt4ZBwXPhA+Hj4
bPhq+Gb4brivdPfia73GIVwSFrc+bwFYfTG7lfn1+b66B+Gd4W/CueGYsEd4
WRngs2wxa4eNw47h10r3vvk3wn+O4NhM013hda3PXwBWTW1hOKXM7e/01e+s
3zzT+QNmmvu81sd2wvFeELYPB8883vq+wcMjOIZrop47p4dFrY8vACtWut9P
rxhBP1bHHeFTpfte4pz+jvrMa4L6muXXw3nh+pnXNK2P8aq6Lmzd+ngCMFnp
9u790QiasbLuD58Ph4XNWx+/AZ6fzcKJ4YYRHPtV8V/h4NbHD4BnKt3vmu8v
c+P9/vo5uroX7ZvCwtbHruFztlU4Odw0gudkZZ2T+TkDGJPSvd8/9r186vve
f1+63/Nf2PqYjU3pPjtwWvj+CJ6rFbkybNj6mAFkFvOaMu73+28v3fsSL299
rOaKmJ1Kt0fTHSN4/ib5QVjS+lgBZBTzljLO76TX3/X/sr42aX2M5rqYXw3X
jOA5nU39fsOBrY8RQCal26/miRE0YFn18Xwu7ND6+Mw3pdvj4OoRPMezOb31
8QHIoHT72I3pe2SPhgvClq2PzXxXuv2crhzBc/5snw4LWh8fgPmodHv6nDWC
a/3T6t8e6t66m7Y+NtnEvDZ8fQTnwLLq33xGuT8TwFwVs6h0e9K3vsZX/xM+
EjZqfVyyi9klXD6Cc+JpVxXf7wCYipjnj+gaX/fdtxfcyMS8OnxlBOdHdYPX
hgBrJubF4dsjuKbfGw5ofTxY4fmyTxnH/Z5uKwn2cwToQ+nu2/u9xtfx+pn+
+pmDF7Q+Hqz0ebN+uHgErwHqfRp9NgRgFdTelvZ7xNd72P1C62PBap9De4V7
Gp9DtxR/CwBYKaW7x/zfNrxm/3s4NKzV+liwxufS4tJ9N6/la4Abw4taHwuA
MSvdd/wubXit/lbYrPVxYOrn1Z7h7obnVX0v6fmtjwPAWJXuPvEtrs91P6Ez
wqLWx4Dezq36N6VPlnZ7R10R1m59HADGJuaURtflB8LerdfPYOfZ7qX7bF6L
c+2Lxf2DAf5fzJGNrsffCC9tvX4GP9/qewGt9pQ4u/X6AcYgZr/w5MDX4KfC
B/0ulld97sMfN3oN8But1w/QUszrS7ef7pDX3p+GPVuvnXEobe4n9XjYrfXa
AVqI2TI8OPB1976wY+u1My4xBzZ4HVo/d7JV67UDDKl03/Efen+fW4s9WZkg
5jUzTR7ynKz7Wy5uvXaAocR8fODr7HfChq3XzbjFbB3+eeBz82thQeu1A/St
dJ/3G/L6Wu8Tv17rdTM31NeJ4ZqBz9H3t143QJ9itijD/s3/kvBzrdfN3BLz
vHDZgOdp/f7L61qvG6APtcOlex9+qGvqOcUe/qym0u1FfeaA5+sPwwat1w0w
bTM9Hupaekbr9TI/xPzRgOftF1qvF2CaYt4+4DX04tbrZf6IWVC7POD5e0zr
NQNMQ8zLS7fnzhDXzq8We/oxZTHrlO4efkOcw3Ufgp1arxlgTZRuj9VrB7pu
1s9sr9t6zcxPMRuEWwY6l+u+AO4VCMxZMb890PXyu8Vnp+hZzGal20NyiHP6
1NbrBVgdMZuEhwa4Tt5d3MOPgcTsNNB5/WjYrvV6AVZV6b573/c18gHXSIYW
s/tMn/s+v68uvsMKzCEz18e+r42PhV1ar5WcYt5ZhrlvoHsFA3NC6fb5+f4A
18XjWq+V3GLeO8B5Xr87s3HrtQKsSMz7Brgmfqn1OqGKOXuA8/3PWq8T4LnE
bB4e7vlaeHfxWX9GonTvd900wGuAV7deK8AkMV/s+Rr4eNi19TphWTFLSvd5
lD7P/bNbrxNgNjFvHuB3oJNarxNmE3NKz+d+3XfAdwGAUSnd/VLv7Pn6d7nr
H2NVur0ur+/5Z2C31usEWFbM0T1f9+4NG7ZeJzyXmB1Kt39/Xz8Hx7deI8DT
YhaFu3ru/x6t1wkrI+bEHn8ODm+9PoCnxRzac/svab1GWFmlu19wX/cK3L/1
+gCqmWvd7T22v+6zvknrdcKqiNm69PM9WO+DAaMQ866ef/d/T+s1wuqI+a0p
/yw8El7Sel0AMWuFm3ts/41hYet1wuqY+fm4coo/D+e2XhNAFbNvj+1/KvxS
6zXCmijdfpjTuFdwvdege1wDoxBzQ4/9v6D1+mAaynTuFXxe63UAVDFv6rH9
/1bs7888EnPAzHtaq/PzcHFY1HoNAFXp7/tNle84M+/EHBWeXMWfhQ+1ftwA
T4t5bY/tv6P4zB/zVMw2M7/PP7GCn4N/Coe0frwAy4q5sMf+H9l6fdC3mC3C
meGy8PVwXfhOODVs2/rxATxbzDplOp9nnk3d43/t1msEAJ4p5p09/u5/bOv1
AQDLK909ePto/7+GdVuvDwB4ppiNV+JzS6vrd1uvDwBYXsxxPbX/wbC49foA
gOWVbj/+Pvp/euu1AQDLi3llT+2v9zTbsPX6AIDlxZzRU/8vbb02AGB5MQtK
9938Pvq/d+v1AQDLi9mjp/b/uNjrFwBGKeasnvr/sdZrAwBmV/r73P+S1msD
AJYXs0FZ/fuWP5ebWq8NAJhdzH49/e5/Quu1AQCzi/lED+1/MmzSem0AwOxi
bumh/3/del0AwOzq7+g9vfd/dOu1AQCzi3l3T/3ftvXaAIDZxVzYQ/vvbb0u
AGCymDt76P9nW68LAJhdzBY9vfd/SOu1AQCzq53uqf8va702AGB2pZ/7/d7e
el0AwGQxX+qh/+e3XhcAMFnMrT30/8DW6wIAZhezKDzeQ/83ar02AGB2Mdv2
0P4ft14XADBZzFt76P/VrdcFAEwWc1IP/f9U63UBAJPFfKaH/p/Yel0AwGQx
3+yh//u0XhcAMFnMAz30f5vW6wIAZhfz4h7aX79LuKj12gCA2cXs2kP/b2u9
LgBgspg399D/r7ReFwAwWcxBPfT/rNbrAgAmizmih/7/Tut1AQCTxRzfQ/+P
ab0uAGCymFN76P/BrdcFAEwWc2YP/X9763UBAJPFnN9D//dovS4AYLKYS3ro
/y+2XhcAMFnMl3vo//at1wUATBZzVQ/9f2nrdQEAk8Vc30P/F7deFwAwWcyt
U27/z8KC1usCACaLuWvK/X+09ZoAgOcWc7f+A0Au+g8A+eg/AOSj/wCQj/4D
QD76D5BbzKZh//DhcEW4N9zPvPdUmW7/l45gTQBZ1FbXZtd214ZvugrdXxRO
C0+U6XcAABhObflpYdEK2r9juHEEjxcAmJ7a9h0ntH/n8OgIHiMAMH218Ts/
q/1rh5tH8NgAgP7U1q+9TP8/OoLHBAD076Mz7d8uPDmCxwMA9K82v7b/iBE8
FgBgOLX9F4zgcQAAwzk/3DCCxwEADKe233f+ACAX7QcAAAAAAAAAAAAAAAAA
AAAAgPnhqfAQADA1ta2t+74it9X7CgMA01HbOoK+6z8ADEj/ASAf/QeAfPQf
APLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf
/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8A
yEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0
HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEg
H/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/
AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B8
9B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8B
IB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLR
fwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeA
fPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/
ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy
0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0H
gHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH
/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A
8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9
B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDI
R/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQf
APLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf
/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8A
yEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0
HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/AMhH/wEg
H/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B89B8A8tF/
AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8BIB/9B4B8
9B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLRfwDIR/8B
IB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeAfPQfAPLR
fwDIR/8BIB/9B4B89B8A8tF/AMhH/wEgH/0HgHz0HwDy0X8AyEf/ASAf/QeA
fPQfAPLRfwDIR/8BIJ850v97w14AwNTUtrbuOwAAAAAAAAAAAAAAAAAAAAAA
AACw6n4ygscAAAyntv+KETwOAGA4tf0fGcHjAACGU9t/wAgeBwAwnNr+9cOP
RvBYAID+1eavv3Rp/deyzwgeDwDQv31q+58Wc9EIHhMA0J+Llm3/TP8Xh+tG
8NgAgOmrjV/87P7PvAZYGE4Oj43gcQIAa642vbZ94Wztf9brgCXhqvDICB43
ALDqasNry5esqPsT3g/YKRwWzgrnAgCjVVtdm13bvcLf9wEAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABg
Tf0vqgDCkA==
         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> (Needs["GeometricOptics`"]; 
       GeometricOptics`CheckInstalledPackages[]; Null), Method -> "Queued", 
      ImageSize -> {50, 50}, Appearance -> "Frameless", Evaluator -> 
      Automatic], "\"Check installed package from Geometric Optics book\"", 
     LabelStyle -> "TextStyling"], 
    Annotation[#, "Check installed package from Geometric Optics book", 
     "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3Xm4rVV92PGXCzIoqCCKiiPRpprBKk4FI8Y5xRiGqjRqG1SMRIsoaOtT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         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> SystemOpen[GeometricOptics`$MainDirectory], Method -> 
      "Queued", Appearance -> "Frameless", ImageSize -> {50, 50}, Evaluator -> 
      Automatic], "\"Open GeometricOptics main folder\"", LabelStyle -> 
     "TextStyling"], 
    Annotation[#, "Open GeometricOptics main folder", "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3XmsbWddx+HV3sK9hHlMK0jDINVggSDIJJQGMBZlEFoiIQQpFChlkknQ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         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "XMP" -> Association[
            "DublinCoreSchema" -> Association["Format" -> "image/png"], 
             "PhotoshopSchema" -> Association["ColorMode" -> 3], 
             "BasicSchema" -> 
             Association["CreateDate" -> DateObject[{2016, 6, 22}, 
                 TimeObject[{15, 8, 44.}, TimeZone -> 2.], TimeZone -> 2.], 
               "CreatorTool" -> "Adobe Photoshop CC 2015 (Windows)", 
               "MetadataDate" -> DateObject[{2016, 6, 27}, 
                 TimeObject[{8, 53, 52.}, TimeZone -> 2.], TimeZone -> 2.], 
               "ModifyDate" -> DateObject[{2016, 6, 27}, 
                 TimeObject[{8, 53, 52.}, TimeZone -> 2.], TimeZone -> 2.]], 
             "MediaManagementSchema" -> 
             Association[
              "DocumentID" -> 
               "adobe:docid:photoshop:df4868ef-3c33-11e6-96f2-f3e0b7188877", 
               "History" -> 
               Association[
                "History[1]" -> 
                 Association[
                  "Action" -> "created", "InstanceID" -> 
                   "xmp.iid:76a07fd1-5d4b-a44e-9815-e09e90530e2c", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)"], "History[2]" -> 
                 Association[
                  "Action" -> "saved", "InstanceID" -> 
                   "xmp.iid:b4a1237b-7af9-f242-a432-98984970be84", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)", "Changed" -> "/"]], 
               "InstanceID" -> "xmp.iid:b4a1237b-7af9-f242-a432-98984970be84",
                "OriginalDocumentID" -> 
               "xmp.did:76a07fd1-5d4b-a44e-9815-e09e90530e2c"], 
             "RightsManagementSchema" -> 
             Association[
              "History" -> 
               Association[
                "History[1]" -> 
                 Association[
                  "Action" -> "created", "InstanceID" -> 
                   "xmp.iid:76a07fd1-5d4b-a44e-9815-e09e90530e2c", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)"], "History[2]" -> 
                 Association[
                  "Action" -> "saved", "InstanceID" -> 
                   "xmp.iid:b4a1237b-7af9-f242-a432-98984970be84", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)", "Changed" -> "/"]]], 
             "PagedTextSchema" -> 
             Association[
              "History" -> 
               Association[
                "History[1]" -> 
                 Association[
                  "Action" -> "created", "InstanceID" -> 
                   "xmp.iid:76a07fd1-5d4b-a44e-9815-e09e90530e2c", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)"], "History[2]" -> 
                 Association[
                  "Action" -> "saved", "InstanceID" -> 
                   "xmp.iid:b4a1237b-7af9-f242-a432-98984970be84", "When" -> 
                   Missing["Disputed"], "SoftwareAgent" -> 
                   "Adobe Photoshop CC 2015 (Windows)", "Changed" -> "/"]]]], 
           "Comments" -> 
           Association[
            "XML:com.adobe.xmp" -> 
             "<?xpacket begin=\:feff id=W5M0MpCehiHzreSzNTczkc9d?><x:xmpmeta \
xmlns:x=adobe:ns:meta/ x:xmptk=Adobe XMP Core 5.6-c067 79.157747, \
2015/03/30-23:40:42> <rdf:RDF \
xmlns:rdf=http://www.w3.org/1999/02/22-rdf-syntax-ns#><rdf:Description \
rdf:about=xmlns:xmp=http://ns.adobe.com/xap/1.0/xmlns:dc=http://purl.org/dc/\
elements/1.1/xmlns:photoshop=http://ns.adobe.com/photoshop/1.0/xmlns:xmpMM=\
http://ns.adobe.com/xap/1.0/mm/xmlns:stEvt=http://ns.adobe.com/xap/1.0/sType/\
ResourceEvent#xmlns:tiff=http://ns.adobe.com/tiff/1.0/xmlns:exif=http://ns.\
adobe.com/exif/1.0/> <xmp:CreatorTool>Adobe Photoshop CC 2015 \
(Windows)</xmp:CreatorTool> \
<xmp:CreateDate>2016-06-22T15:08:44+02:00</xmp:CreateDate> \
<xmp:ModifyDate>2016-06-27T08:53:52+02:00</xmp:ModifyDate> \
<xmp:MetadataDate>2016-06-27T08:53:52+02:00</xmp:MetadataDate> \
<dc:format>image/png</dc:format> <photoshop:ColorMode>3</photoshop:ColorMode> \
<xmpMM:InstanceID>xmp.iid:b4a1237b-7af9-f242-a432-98984970be84</xmpMM:\
InstanceID> \
<xmpMM:DocumentID>adobe:docid:photoshop:df4868ef-3c33-11e6-96f2-f3e0b7188877</\
xmpMM:DocumentID> \
<xmpMM:OriginalDocumentID>xmp.did:76a07fd1-5d4b-a44e-9815-e09e90530e2c</xmpMM:\
OriginalDocumentID> <xmpMM:History><rdf:Seq> <rdf:li \
rdf:parseType=Resource><stEvt:action>created</stEvt:action><stEvt:instanceID>\
xmp.iid:76a07fd1-5d4b-a44e-9815-e09e90530e2c</stEvt:instanceID><stEvt:when>\
2016-06-22T15:08:44+02:00</stEvt:when><stEvt:softwareAgent>Adobe Photoshop CC \
2015 (Windows)</stEvt:softwareAgent> </rdf:li> <rdf:li \
rdf:parseType=Resource><stEvt:action>saved</stEvt:action><stEvt:instanceID>\
xmp.iid:b4a1237b-7af9-f242-a432-98984970be84</stEvt:instanceID><stEvt:when>\
2016-06-27T08:53:52+02:00</stEvt:when><stEvt:softwareAgent>Adobe Photoshop CC \
2015 (Windows)</stEvt:softwareAgent><stEvt:changed>/</stEvt:changed> \
</rdf:li></rdf:Seq> </xmpMM:History> <tiff:Orientation>1</tiff:Orientation> \
<tiff:XResolution>752856/10000</tiff:XResolution> \
<tiff:YResolution>752856/10000</tiff:YResolution> \
<tiff:ResolutionUnit>2</tiff:ResolutionUnit> \
<exif:ColorSpace>65535</exif:ColorSpace> \
<exif:PixelXDimension>512</exif:PixelXDimension> \
<exif:PixelYDimension>512</exif:PixelYDimension></rdf:Description> \
</rdf:RDF></x:xmpmeta><?xpacket end=w?>"]]], Selectable -> False], 
       DefaultBaseStyle -> "ImageGraphics", ImageSizeRaw -> {512, 512}, 
       PlotRange -> {{0, 512}, {0, 512}}], ButtonFunction :> 
      GeometricOptics`SaveLastExample[], Method -> "Queued", 
      ImageSize -> {50, 50}, Appearance -> "Frameless", Evaluator -> 
      Automatic], "\"Save last example calculated\"", LabelStyle -> 
     "TextStyling"], 
    Annotation[#, "Save last example calculated", "Tooltip"]& ],TagBox[
    TooltipBox[
     ButtonBox[
      GraphicsBox[
       TagBox[
        RasterBox[CompressedData["
1:eJzt3X/sZXlZ2PGzO4szhF/yQzJTqBuQsho6YKgW1AJulKZDi1rcNRJCLAsr
IogWkWqbNkrHmqootkln3NKlWChoBCGEUEBap9gEKkQQ1HZoBDJAShf5NSwL
ykqfT+5O8nWc2f3OnHuf57nnvk7y0ug/e+55Pvm879zvvec85IYffcoPXjlN
048fiv/xlGf8k2tf8IJn/NT3fnX8H9c//8ef8+zn3/isY89/4Y3PvvEFj73h
QPw/pytXror/9ZWvfGVx4rgiXB2eFH4ivCy8Lrw9vDt8MHwifHFcAgB20pfC
LeFPwnvDO8KbwivDT4enhkeHe1Z3jYv2/kHhGeHm8K5wtsG6AmA5Pjqt/g15
PFwbDla3bxfFMT7oeGL4xfD+BusCgN3yhfC28JPhm8MV1W1csji+PfznO657
9ewB4JyPhJ8N11S3cinieEB4YfjfDeYLAHdl/B36ueH+1Q3dRnE8Mrx6Wn0/
o3qWAHCpRr9uCg+tbuo2iOPh06r7f9FgdgAw15+HV0z+NnCx7l8d/kP4coNZ
AcC63R5eEx5R3dwO4rhHeMnkc34AdsP4PGB0b2fvKxDHd0yr+y5UzwIAso17
Clxf3eLk7o97E76swbUHgGpvCQ+rbnNC+78rfKzB9QaALsZ9bZ5V3egNdX88
euDnG1xjAOjqVdOCvhcQx/3CWxtcVwDobtzv7lHV7V5D+x81+Y4fAFyK28KN
1Q2f0f7vD7c2uI4AsI2OV7f8Mtr/7Mk9/ABgrnEP4QPVXd9n+3+kwfUCgKV4
XThU3fe7aP8LG1wnAFia3wn3ru78Rdr/zxpcHwBYqt8JB6t779/9AJBu/C2g
xfcB4rhu8l0/AMhyU4P2f+u0+p1i9bUAgF3yLwvb/7BwS4NrAAC7KP0eQXHc
P5xu8NoBYFeNz99T7xUcx5savG4A2HXjeQEpzwyK43kNXi8AsPKqhPY/YvJ9
PwDo5lkbbP/B8L4GrxEA+Mu+EB62of7/UoPXBwBc2Fs20P5vmdzjBwC6u36N
7b8y/F6D1wQA3LmPTmv6PUAcz2zweuZ4f/iN8AvT6rcLTw6PDPfZ9PclAegp
jnuFa8K14WnhReGl4Y3h1gbtmuMla7g+9wmfaPBaLtWHw8+Gb6heYwBslzju
Hr47vDx8skHTLtWfh0fMvAa/3OB17Nenw6+Gx4UrqtcPANsvjgPhCeGmO7pa
3br9es2M13zNlrzW28OJ8NXV6wSA5Yrjb4TfbNC9/bbxmst8na9ocP535ffD
Y6rXBAC7Y1r9Ju4dDRp4V15xGa/ta6fe//Y/G/5xOFC9DgDYTXF8T/h/DZp4
MaPjD73E1/RvGpz3xbwnPLh67gAQx9VT73vj3nQJr+UBU9/fPvy3cO/qeQPA
OXHcI7y2QSMv5Evh/vt8HS9ucL4X8vpwqHrOAHC+OK4IPzP1vFfuc/dx/ofC
pxqc6/lunvytH4Dm4nh6w/cA/3Mf531dg/M837gHgd/zA7AVptXnANXtPN+d
3g8vjt9qcI57vVn7Adgm0+pvAd2+D/Bzd3K+951W3xOoPsdzzoQHVM8RAC7V
tPpOYKffBYymXnmRc/3BBud3zvjN4rdWzw8ALte0+m1gp/sDXPB+eXH89wbn
ds4Lq+cGAHNNq3sEVTf1nJ+6wPn9tanP9xXfUD0vAFiXqc+9gn/7Auf29Abn
Ndw23otUzwoA1mVaPS+guq/nGnvwvHO7ucF5Db9UPScAWLepz3MDrz3vvD7U
4Jw+Hx5YPSMAWLdp9ezgDs/VO77nnB7S4HyGi/42EQC2XRw3NWjt2/eczw0N
zuez4X7VswGATYnjCQ16+9E95/NrDc7nxdVzAYBNiuNA+GSD5t7zjvP5/Qbn
8nXVcwGATYvj5Q2a++hpdY/izxefxx9XzwMAMsTx3Q36/9Tw4Abn8fPV8wCA
DHHcPdxa3N2fDt/RoP+Pr54HAGSJ443F3X1l+OHic/hUOFA9CwDIEsdLi9v7
pvArxefwquo5AECmOF5U3N7xPILXFp/Dj1TPAQAyxfG04va+N7y1+ByeUj0H
AMgUx7XF7f2T8M7ic3hM9RwAIFMc1xS395bwh8Xn8ODqOQBApjjuVdzeL4Uz
hf/928NV1XMAgGzF/R8+U/jf/nj19QeACg36f3vhf/s91dcfACo06H+ld1Zf
fwCo0KDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVo
sP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCs
QYP1HwCSNWiw/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeA
ZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/
ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY
/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNAsgYN1n8ASNag
wfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeAZA0arP8AkKxBg/UfAJI1aLD+A0Cy
Bg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8A
kjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/
OyCOg+FYOBlOhdPhbIM1ANQZe8DYC8aeMPaGsUccrN6vdkWD+VfS/82vryPh
RPhcg3kD/Y29YuwZR6r3r6VrMOtK+r+5dXUoHA+3NpgzsH3G3jH2kEPV+9lS
NZhxJf3fzJo6PK5tg/kC22/sJYer97UlajDb0nVVff2XJo6j4UyD2QLLMfaU
o9X729I0mGsl/V/vWjo8aT+wGWNv8TnAevfs6plW0v/1raPx936f+QObNPYY
3wdY375dPc/StVR9/ZdiWn1Pp3qewPIdr97vlqLBLCvp/3rW0PiNn+/5AxnG
XuO3gevZu6tnWUn/17OGTjSYJbA7TlTve0vQYI6V9H/++hn39XNvHyDT2HPc
J3D+/l09x0r6P3/9HGswR2D3HKve/7ZdgxlW0v/56+dkgzkCu+dk9f637RrM
sJL+z18/pxrMEdg9p6r3v23XYIaV9H/++jndYI7A7jldvf9tuwYzrKT/89eP
Z/gCFc5W73/brsEMK+n//PWj/0AF/Z+/f1fPsJL+z18/Pv8HKvj8f/7+XT3D
Svo/f/34/h9Qwff/5u/f1TOspP/z14/f/wEV/P5v/v5dPcNK+j9//bj/D1DB
/X/m79/VM6yk//PXj/v/Atnc/3c9+3f1HCvp/3rWkOf/AJk8/2c9e3f1HCvp
/3rWkOf/Alk8/3d9e3f1LCvp//rW0fEG8wSW73j1frcUDWZZSf/Xt44OjevZ
YKbAco095lD1frcUDeZZupaqr/+SxHE4nGkwV2B5xt5yuHqfW5IGM62k/+tf
T0cn7wGA9Rp7ytHq/W1pGsy1kv5vZk2NzwH8LQBYh7GX+Hf/Zvbq6tmWrqvq
679U0+r7AOM7gX4XAFyOsXeMPcTf+ze3T1fPuJL+b359jd8GjvsDuEcQsB9j
rxh7ht/4bX5/rp51Jf3PW2fjPoHjXsHjeQHjmUHjuYGeHQy7bewBYy8Ye8LY
G8Ye4b5+efty9fwr6T8AO6lBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0
WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjW
oMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNA
sgYN1n8ASNagwfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeAZA0arP8AkKxBg/Uf
AJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs
/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQ
YP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZ
gwbrPwAka9Bg/QeAZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8A
yRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/
AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/OyCOg+FYOBlOhdPh
bIM1ANQZe8DYC8aeMPaGsUccrN6vdkWD+VfS/82vryPhRPhcg3kD/Y29YuwZ
R6r3r6VrMOtK+r+5dXUoHA+3NpgzsH3G3jH2kEPV+9lSNZhxJf3fzJo6PK5t
g/kC22/sJYer97UlajDb0nVVff2XJo6j4UyD2QLLMfaUo9X729I0mGsl/V/v
Wjo8aT+wGWNv8TnAevfs6plW0v/1raPx936f+QObNPYY3wdY375dPc/StVR9
/ZdiWn1Pp3qewPIdr97vlqLBLCvp/3rW0PiNn+/5AxnGXuO3gevZu6tnWUn/
17OGTjSYJbA7TlTve0vQYI6V9H/++hn39XNvHyDT2HPcJ3D+/l09x0r6P3/9
HGswR2D3HKve/7ZdgxlW0v/56+dkgzkCu+dk9f637RrMsJL+z18/pxrMEdg9
p6r3v23XYIaV9H/++jndYI7A7jldvf9tuwYzrKT/89ePZ/gCFc5W73/brsEM
K+n//PWj/0AF/Z+/f1fPsJL+z18/Pv8HKvj8f/7+XT3DSvo/f/34/h9Qwff/
5u/f1TOspP/z14/f/wEV/P5v/v5dPcNK+j9//bj/D1DB/X/m79/VM6yk//PX
j/v/Atnc/3c9+3f1HCvp/3rWkOf/AJk8/2c9e3f1HCvp/3rWkOf/Alk8/3d9
e3f1LCvp//rW0fEG8wSW73j1frcUDWZZSf/Xt44OjevZYKbAco095lD1frcU
DeZZupaqr/+SxHE4nGkwV2B5xt5yuHqfW5IGM62k/+tfT0cn7wGA9Rp7ytHq
/W1pGsy1kv5vZk2NzwH8LQBYh7GX+Hf/Zvbq6tmWrqvq679U0+r7AOM7gX4X
AFyOsXeMPcTf+ze3T1fPuJL+b359jd8GjvsDuEcQsB9jrxh7ht/4bX5/rp51
Jf3PW2fjPoHjXsHjeQHjmUHjuYGeHQy7bewBYy8Ye8LYG8Ye4b5+efty9fwr
6T8AO6lBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr
0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEg
WYMG6z8AJGvQYP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNAsgYN1n8ASNagwfoP
AMkaNFj/ASBZgwbrPwAka9Bg/QeAZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3W
fwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVo
sP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCs
QYP1HwCSNWiw/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeA
ZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/
ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY
/wEgWYMG6z8AJGvQYP0HgGQNGqz/OyCOg+FYOBlOhdPhbIM1ANQZe8DYC8ae
MPaGsUccrN6vdkWD+VfS/82vryPhRPhcg3kD/Y29YuwZR6r3r6VrMOtK+r+5
dXUoHA+3NpgzsH3G3jH2kEPV+9lSNZhxJf3fzJo6PK5tg/kC22/sJYer97Ul
ajDb0nVVff2XJo6j4UyD2QLLMfaUo9X729I0mGsl/V/vWjo8aT+wGWNv8TnA
evfs6plW0v/1raPx936f+QObNPYY3wdY375dPc/StVR9/ZdiWn1Pp3qewPId
r97vlqLBLCvp/3rW0PiNn+/5AxnGXuO3gevZu6tnWUn/17OGTjSYJbA7TlTv
e0vQYI6V9H/++hn39XNvHyDT2HPcJ3D+/l09x0r6P3/9HGswR2D3HKve/7Zd
gxlW0v/56+dkgzkCu+dk9f637RrMsJL+z18/pxrMEdg9p6r3v23XYIaV9H/+
+jndYI7A7jldvf9tuwYzrKT/89ePZ/gCFc5W73/brsEMK+n//PWj/0AF/Z+/
f1fPsJL+z18/Pv8HKvj8f/7+XT3DSvo/f/34/h9Qwff/5u/f1TOspP/z14/f
/wEV/P5v/v5dPcNK+j9//bj/D1DB/X/m79/VM6yk//PXj/v/Atnc/3c9+3f1
HCvp/3rWkOf/AJk8/2c9e3f1HCvp/3rWkOf/Alk8/3d9e3f1LCvp//rW0fEG
8wSW73j1frcUDWZZSf/Xt44OjevZYKbAco095lD1frcUDeZZupaqr/+SxHE4
nGkwV2B5xt5yuHqfW5IGM62k/+tfT0cn7wGA9Rp7ytHq/W1pGsy1kv5vZk2N
zwH8LQBYh7GX+Hf/Zvbq6tmWrqvq679U0+r7AOM7gX4XAFyOsXeMPcTf+ze3
T1fPuJL+b359jd8GjvsDuEcQsB9jrxh7ht/4bX5/rp51Jf3PW2fjPoHjXsHj
eQHjmUHjuYGeHQy7bewBYy8Ye8LYG8Ye4b5+efty9fwr6T8AO6lBg/UfAJI1
aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQ
rEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0H
gGQNGqz/AJCsQYP1HwCSNWiw/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZgwbr
PwAka9Bg/QeAZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0
WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjW
oMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNA
sgYN1n8ASNagwfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeAZA0arP8AkKxBg/Uf
AJI1aLD+A0CyBg3WfwBI1qDB+g8AyRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs
/wCQrEGD9R8AkjVosP4DQLIGDdZ/AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQ
YP0HgGQNGqz/AJCsQYP1HwCSNWiw/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZ
gwbrPwAka9Bg/QeAZA0arP8AkKxBg/UfAJI1aLD+A0CyBg3WfwBI1qDB+g8A
yRo0WP8BIFmDBus/ACRr0GD9B4BkDRqs/wCQrEGD9R8AkjVosP4DQLIGDdZ/
AEjWoMH6DwDJGjRY/wEgWYMG6z8AJGvQYP0HgGQNGqz/AJCsQYP1HwCSNWiw
/gNAsgYN1n8ASNagwfoPAMkaNFj/ASBZgwbrPwAka9Bg/QeAZA0afHvhf/s9
1dcfALLFcZ/i9n8xfKbwv/+x6hkAQLY4Hlnc/0+EM4X//S+HA9VzAIBMcTy5
uP8fDH9YfA5HqucAAJnieF5xe98d3ll8Dt9UPQcAyBTHLxS39+3hrcXn8F3V
cwCATHH8RnF7Xxd+s/gcnlM9BwDIFMcHitv7svDS4nN4TfUcACBLHH+zuLvD
T4QfLj6Hz4avqp4HAGSY6v/2PzwpfGeD8/i71fMAgE2L40D4eIPuXh2+tsF5
/LvqmQDApsXx9xo092y44g63FZ/LR8d5VM8FADYpjlc36P+79pzP+xucz9+u
ngsAbEocR8IXGvT25j3n9MoG5/P66tkAwKZM9b/5P+cf7TmnZzY4n+HbqucD
AOsWx99v0Nhzjuw5r4c2OJ/hf1TPCADWKY57hI80aOzwvguc34cbnNfwD6tn
BQDrEsdLGrT1nH99gfO7ucF5Df8rXFU9LwCYK45HT6tn3Ve39ZxrL3COT29w
Xuf8TPXMAGCOOB489flsfRi/+/8r99uN43Cj9yh/Eb63enYAcDniuH/4owY9
3es/3sn5vrnB+Z3z+fCo6hkCwKWI417h9xp09HyPvZNzfmqD89vrw+FrqmcJ
APsRx8HwXxv083zvvYvzvvu0eh5f9Xnu9Y7J8wEBaC6OQ+H1Dbp5IT+0j/N/
WYPzPN/vhgdWzxYALiSOh49/Yzfo5YWM7/3dax+v4XENzvVCxr0TvrF6xgCw
VxxPu6Ox1Z28mJP7fB3jeYAdngd0IbeG66pnDQDT6m/mHT8z3+vPwkMu4TV1
+x7gXuO3gS8Od6uePQC7KY5vmvr+W3mvE5f4ug6E0w3O+858MFxfvQYA2B1x
fGN4Q4MG7sdt4UGX8RpvaHDu+/Gu8ITqNQHAcsVxNLx2Wn0GXd29/XrJZb7W
u019nle0H28M3xaurF4nAGy/afVZ+OPDr29Z94fxfcTLvn9OHM9p8Bou1f8N
/z78g3Coev0AsD3iuHf4vvCfwp82aNrl+uczr8NV4Q8avI7LNe4h/LrwY+H6
afX5wEPCweo1BkCdOzp/Tbh2Wv1+7yfD26bV9+Wr2zXX6Pbs78hPfe8HMNcn
wwem1f0aANgN47vj49+G1Q3alPEcv7+1xvdJr2jwmgCAO/dza/6c5IHh0w1e
FwBwYX88beDv23E8t8FrAwD+qvG5/7ds6LsSV4a3NHiNAMBf9mMb/r7k14SP
NXidAMDKr22y/XveA4x7IXy5wesFgF337inxXjdx/NMGrxkAdtknwl/Pav8d
/R/PCH5zg9cOALvoi+Hxme3f8x7gPuF9Da4BAOyScY/CJ1e0f897gCPhQw2u
BQDsgvH9u+sq27/nPcDDwy0NrgkALNnt4WnV3T/vPcA3T8u+nzIAVBrPH35m
de8v8h7gOyfvAQBg3b4UfqC683fxHuAx0+q5etXXCgCW4E/DE6r7vs/3AF8f
PtLgmgHANjsdHl7d9Ut8D/Cg8IEG1w4AttGpcL/qnl/me4D7ht9ucA0BYJv8
2/BV1R2f+R5gPDPwX0yeFwAAd2Xcz/dJ1e1e8/uAbw8fb3BtAaCjN4UHVvd6
Q+8BxrOD/0uDawwAXdwWnlfd6IT3AOO5QT8UPtXgmgNApdeHr6tuc8FnAS+f
Vvczqr7+AJDpj8ITq1tc/D7g74Q/aDALANi0T4cfDVdV97eDcR3Ccyb3DAJg
mT4T/lV4QHVzO4rjbuGGaXW/o+pZAcBc43dvLwr3rm7sNojjQHhqeH+D2QHA
pRr/jr0xHKxu6jaaVr8VeFy4aVr9zaR6ngBwMeM5PSem1ffarqhu6FLEcTBc
F94Q/qzBnAHgC+HXw5PD3apbuXRx3C98X/jV8H8azB+A3XB7eE/4xfCkcM/q
Ju6yOK6eVt8bfOW0+s7AbQ3WCADb75bwu+FXwveE+1Y3jzt9PzCeOXR1eGJ4
7h1ze214W3jntLrvwpnw2Wn1Xq56fQGQZ/wN+ZPhQ+F906rvbw6vnla/0fuB
8NhpS5+9eyn+Px+iCWU=
         "], {{0, 512}, {512, 0}}, {0, 255}, ColorFunction -> RGBColor], 
        BoxForm`ImageTag[
        "Byte", ColorSpace -> "RGB", Interleaving -> True, MetaInformation -> 
         Association[
          "Comments" -> Association["Software" -> "www.inkscape.org"]]], 
        Selectable -> False], DefaultBaseStyle -> "ImageGraphics", 
       ImageSizeRaw -> {512, 512}, PlotRange -> {{0, 512}, {0, 512}}], 
      ButtonFunction :> GeometricOptics`SaveExampleFromList[], Method -> 
      "Queued", Appearance -> "Frameless", ImageSize -> {50, 50}, Evaluator -> 
      Automatic], 
     "\"Save an example from the stack of current session's examples\"", 
     LabelStyle -> "TextStyling"], 
    Annotation[#, 
     "Save an example from the stack of current session's examples", 
     "Tooltip"]& ]},
  "RowWithSeparator"]]]
},
WindowSize->All,
WindowMargins->{{Automatic, 17}, {20, Automatic}},
WindowElements->{},
WindowTitle->"Geometric Optics main palette",
CellMargins->{{20, 20}, {10, 10}},
Background->GrayLevel[1],
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Palette.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[602, 21, 90947, 1553, 74, InheritFromParent]
}
]
*)

